;;; File: monitor.clp
;;; Monitoring a gas-turbine 

;;;         .
(deffacts initial-data
	(temp-sensor t1 300)
	(temp-sensor t2 600)
	(press-sensor p1 5)
	(press-sensor p2 9)
	(fire-sensor off)
	(sensor rpm 8000)
)

;;;  datasets         
;;;  .    format.
;;; (data Num t1 t2 p1 p2 fire rpm)

(deffacts datasets
	(data 1 300 500 4 5 on 7000)
	(data 2 300 500 4 8 on 7000)
)



;;;       .
(defrule initial
	(initial-fact)
	=> 
	(assert (phase detection))
	(assert (cycle 1))
)

;;;      sensors. 
(defrule new-data
	(phase collect-data)
	(not (values changed))
	?cycl <- (cycle ?x)
	(data ?x ?newt1 ?newt2 ?newp1 ?newp2 ?newn ?newrpm)
	?f1 <- (temp-sensor t1 ?t1)
	?f2 <- (temp-sensor t2 ?t2)
	?f3 <- (press-sensor p1 ?p1)
	?f4 <- (press-sensor p2 ?p2)
	?f5 <- (fire-sensor ?n)
	?f6 <- (sensor rpm ?rpm)
	=> 
	(assert (values changed))
	(retract ?cycl)
	(assert (cycle (+ 1 ?x)))
	(retract ?f1 ?f2 ?f3 ?f4 ?f5 ?f6)
	(assert (temp-sensor t1 ?newt1))
	(assert (temp-sensor t2 ?newt2))
	(assert (press-sensor p1 ?newp1))
	(assert (press-sensor p2 ?newp2))
	(assert (fire-sensor ?newn))
	(assert (sensor rpm ?newrpm))
)

;;;         
;;;  .
(defrule cleanup
	(declare (salience -2))
	(phase collect-data)
	?s <- (symptom $?)
	=> 
	(retract ?s)
)

;;;         
;;;  .
(defrule cleanup2
	(declare (salience -2))
	(phase collect-data)
	?d <- (diagnosis $?)
	=> 
	(retract ?d)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;	
;;;;;;;;; PHASE DETECTION
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;         
;;; . 
(defrule check-temperature
	(phase detection)
	(temp-sensor ?s ?x)
	(test (> ?x 400))
	=> 
	(printout t " High temperature in" ?s crlf)
	(assert (symptom temp ?s high))
)

;;;          
;;; .
(defrule check-pressure-high
	(phase detection)
	(press-sensor ?p ?x)
	(test (> ?x 8))
	=> 
	(printout t " High pressure in" ?p crlf)
	(assert (symptom pressure ?p high))
)

;;;         
;;; .

(defrule check-pressure-low
	(phase detection)
	(press-sensor ?p ?x)
	(test (< ?x 3))
	=> 
	(printout t " Low pressure in" ?p crlf)
	(assert (symptom pressure ?p low))
)

;;;       

(defrule fire-sensor
	(phase detection)
	(fire-sensor on)
	=> 
	(printout t "FIRE IN THE PREMISES !!!" crlf)
	(assert (symptom fire))
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;; PHASE DIAGNOSIS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;       .

(defrule blocked-exit-pipe
	(phase diagnosis)
	(symptom pressure p2 high)
	(symptom temp t2 high)
	(sensor rpm ?r)
	(test (<= ?r 8000))
	=> 
	(assert (diagnosis blocked exit pipe))
) 

;;;       .

(defrule overworking
	(phase diagnosis)
	(symptom pressure p2 high)
	(symptom temp t2 high)
	(sensor rpm ?r)
	(test (> ?r 8000))
	=> 
	(assert (diagnosis engine overworking))
) 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;; Phase Isolation
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;       

(defrule fix-engine-overworking
	(phase isolation)
	(diagnosis engine overworking)
	=> 
	(printout t " Reduce Fuel " crlf)
)

;;;       

(defrule fix-exit-pipe
	(phase isolation)
	(diagnosis blocked exit pipe)
	=> 
	(printout t " Close main pipe  Open backup pipe " crlf)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; CONTROL RULES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;       detect  diagnosis

(defrule detect-diagnose
	(declare (salience -10))
	?d <- (phase detection)
	=> 
	(retract ?d)
	(printout t "Switching from detect to diagnose" crlf)
	(assert (phase diagnosis))
)

;;;       diagnosis  isolation

(defrule diagnose-isolate
	(declare (salience -10))
	?d <- (phase diagnosis)
	=> 
	(retract ?d)
	(printout t "Switching from diagnose to isolate" crlf)
	(assert (phase isolation))
)

;;;       isolation  collect-data

(defrule isolate-collect-data
	(declare (salience -10))
	?d <- (phase isolation)
	=> 
	(retract ?d)
	(printout t "Switching from isolate to collect-data" crlf)
	(assert (phase collect-data))
)

;;;       collect-data  detection

(defrule collect-data-detection
	(declare (salience -10))
	?d <- (phase collect-data)
	?e <- (values changed)
	=> 
	(retract ?d ?e)
	(printout t "Switching from collect-data detect" crlf)
	(assert (phase detection))
)





 



	